document.addEventListener("DOMContentLoaded", function() {
    // Retrieve the rowData from the session
    var rowData = sessionStorage.getItem('rowData');
    var rowDataObj = JSON.parse(rowData);
    // Log the rowDataObj to the console
    console.log(rowDataObj);
    
    //////Variables para el cálulo///
    const tic = rowDataObj["tic"];
    localStorage.setItem('tic', tic);
    const tcv = rowDataObj["tcv"];
    localStorage.setItem('tcv', tcv);
    const kic = rowDataObj["kic"];
    localStorage.setItem('kic', kic);
    const kcv = rowDataObj["kcv"];
    localStorage.setItem('kcv', kcv);
    const plzo= rowDataObj["Plazo de inversión"];
    console.log("Plazo:", plzo)
    localStorage.setItem('plazo', plzo);
    const monto= rowDataObj["Monto a Aportar"];
    localStorage.setItem('monto', monto);
    const moda= rowDataObj["Modalidad de Inversión"];
    localStorage.setItem('moda', moda);
    const fechai= rowDataObj["Fecha de inicio"];
    localStorage.setItem('fechai', fechai);
    
    let monto_inicial;
    if(moda== "Aportacin nica"){
        monto_inicial= rowDataObj["Monto Inicial a Aportar"];
    } else {
        monto_inicial = 0
    }

    localStorage.setItem('monto_inicial', monto_inicial);
    const tiempoTranscurrido = Date.now();
    const fecha = new Date(tiempoTranscurrido)
    var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    //const hoy = fecha.getDate();
    const formattedDate = fecha.toLocaleDateString('es-ES', options);
    document.getElementById('hoy').textContent = formattedDate
    document.getElementById('hoy2').textContent = formattedDate
    document.getElementById('hoy3').textContent = formattedDate
    document.getElementById('hoy4').textContent = formattedDate
    
    
    // Unpack each variable
    const typeinv = rowDataObj["Tipo de inversionista"].trim(); 
    console.log( typeinv);
    console.log("Nombre completo:", rowDataObj["Nombre completo"]);
    console.log("Nombre completo:", rowDataObj["Fecha de Nacimiento"]);
    console.log("Nombre completo:", rowDataObj["07Desea designar beneficiarios de esta inversin?"]);
    
    let nombrePF;
    let nacimiento;
    let edoCivil;
    let origen;
    let refis;
    if (typeinv === "Persona moral")  {
        nombrePF = rowDataObj["Razn Social"];
        refis = rowDataObj["Nombre de Representante Legal"].replace(/,/g, '');
        nacimiento = rowDataObj["Fecha de Constitucin"];
        edoCivil = rowDataObj["Principales Actividades Econmicas"];
    
        document.getElementById("declaration").textContent = " por medio de su representante legal";
        document.getElementById("comprador").textContent = nombrePF;
        document.getElementById("conducto").textContent = "Representada: " + nombrePF;
        document.getElementById("conducto2").textContent = "Representada: " + nombrePF;
        document.getElementById("nombre").textContent = "Representante legal: " + refis;
        document.getElementById("nombre2").textContent = "Representante legal: " + refis;
        document.getElementById("estado_civil").textContent = ", representada legalmente por " + nombrePF;
        document.getElementById("estado_origen").textContent = "Es una persona moral debidamente constituida";
        document.getElementById("regimen_fiscal").textContent = ", con actividad econmica  " + edoCivil;
    } else {
        nombrePF = rowDataObj["Nombre completo"].replace(/,/g, '');
        nacimiento = rowDataObj["Fecha de Nacimiento"];
        edoCivil = rowDataObj["Estado Civil"];
        origen = rowDataObj["Lugar de Origen"];
        
        
        
    
        document.getElementById("declaration").textContent = " por su propio derecho";
        document.getElementById("comprador").textContent = "POR SU PROPIO DERECHO " + nombrePF;
        document.getElementById("conducto").textContent = "Por su propio derecho: ";
        document.getElementById("conducto2").textContent = "Por su propio derecho: ";
        document.getElementById("nombre").textContent = "Nombre: " + nombrePF;
        document.getElementById("nombre2").textContent = "Nombre: " + nombrePF;
        document.getElementById("estado_civil").textContent = ", estado civil " + edoCivil;
        document.getElementById("estado_origen").textContent = "Ser de nacionalidad Mexicana, originario de " + origen;
        
    }
    
    console.log(nacimiento);
    console.log(nombrePF);
    console.log(edoCivil);
    //document.getElementById("tipo_inversionista").textContent = typeinv;
    

    
    document.getElementById("denominacion").textContent = nombrePF;
    const domicilio = rowDataObj["Domicilio"];
    // Create a new DOMParser object
    var parser = new DOMParser();
    
    // Use the parseFromString method to parse the HTML string
    var doc = parser.parseFromString(domicilio, 'text/html');
    // Get the parsed element from the document
    var parsedElement = doc.body.firstChild;

    // Get the container element from the existing HTML
    var container = document.getElementById('domicilio_comprador');
    
    container.appendChild(parsedElement);
    
    document.getElementById("domicilio_comprador").textContent = domicilio;
    const mail = rowDataObj["Email"];
    document.getElementById("email_comprador").textContent = mail;
    const rfc = rowDataObj["RFC"];
    document.getElementById("rfc").textContent = rfc;
    
    //Numero de contrato
    const id = rowDataObj["ID"];
    document.getElementById("numero_contrato").textContent = id;
    document.getElementById("numero_contrato2").textContent = id;
    document.getElementById("numero_contrato3").textContent = id;
    document.getElementById("proyecto2").textContent = id;
    document.getElementById("proyecto3").textContent = id;
    document.getElementById("proyecto4").textContent = id;
    
    //Beneficiarios
    const numben = rowDataObj["\u00BFDesea designar beneficiarios de esta inversi\u00F3n?"];
    console.log("Beneficiarios:", numben)

if (numben !== undefined && numben !== null) {
    if (numben == "1 beneficiario" ) {
        const ben1 = rowDataObj["Informaci\u00F3n Beneficiario 1"].replace(/,/g, '');
        console.log(ben1)
        document.getElementById("beneficiario1").textContent = ben1;
    } else if (numben == "2 beneficiarios" || numben === "3 beneficiarios") {
        const ben1 = rowDataObj["Informaci\u00F3n Beneficiario 1"].replace(/,/g, '');
        console.log(ben1)
        document.getElementById("beneficiario1").textContent = ben1;
        const ben2 = rowDataObj["Informaci\u00F3n Beneficiario 2"].replace(/,/g, '');
        console.log(ben2)
        document.getElementById("beneficiario2").textContent = ben2;
    } else if (numben == "3 beneficiarios") {
        const ben1 = rowDataObj["Informaci\u00F3n Beneficiario 1"].replace(/,/g, '');
        console.log(ben1)
        document.getElementById("beneficiario1").textContent = ben1;
        const ben2 = rowDataObj["Informaci\u00F3n Beneficiario 2"].replace(/,/g, '');
        console.log(ben2)
        document.getElementById("beneficiario2").textContent = ben2;
        const ben3 = rowDataObj["Informaci\u00F3n Beneficiario 3"].replace(/,/g, '');
        console.log(ben3)
        document.getElementById("beneficiario3").textContent = ben3;
    }
} else {
    console.log("El valor de \u00BFDesea designar beneficiarios de esta inversi\u00F3n? es indefinido.");
}
    
    //Fecha de nacimiento formato
    console.log(nacimiento)
    const parts = nacimiento.split(/\s+/);
    const day = parts[0];
    const month = parts[1];
    const year = parts[2];
    const dateObject = new Date(`${year}-${month}-${day}`.replace(/-/g, '\/'));
    
    const nacimientoformatted = dateObject.toLocaleDateString('es-ES');
    if (typeinv== "Persona moral"){
        document.getElementById("fecha_nacimiento").textContent = " en la fecha " + nacimientoformatted;
    } else {
        document.getElementById("fecha_nacimiento").textContent = " lugar en que naci\u00f3 en la fecha " + nacimientoformatted;
    }
    
    const numdias = Math.round(parseFloat(plzo)*30*0.7)
    document.getElementById("numdias1").textContent = numdias+" d\u00edas";
    document.getElementById("numdias2").textContent = numdias+" d\u00edas";
    
    });