document.addEventListener("DOMContentLoaded", function() {
    const submissionID  = '5938723754115313032';
    const apiKey = '4869f3bb5e5570ba840bc043828ec93f';
   var apiUrl = "https://api.jotform.com/submission/" + submissionID + "?apiKey=" + apiKey;

fetch(apiUrl)
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        if (!data.content) {
            throw new Error('data.content is undefined');
        }
        console.log(data);
        // Extract answers from data
        var submissions = data.content;

        var response = data.content.answers;
        const answerTextPairs = [];

        Object.entries(response).forEach(([key, value]) => {
            if (value.hasOwnProperty("answer") && value.hasOwnProperty("text")) {
                // Check if the value is an object
                if (Object.prototype.toString.call(value.answer) === "[object Object]") {
                    value.answer = Object.values(value.answer).join(", ");
                }
                answerTextPairs.push([value.answer, value.text]);
            }
        });

        const newDictionary = answerTextPairs.reduce((dictionary, [answer, text]) => {
            dictionary[text] = answer;
            return dictionary;
        }, {});

        // Assign the newDictionary object to jsonData
        jsonData = newDictionary;

        // Log the jsonData to verify
        console.log(jsonData);
        
        const businessName = jsonData["Razón social"];
        const elements = document.querySelectorAll('.business-name');
         elements.forEach(element => {
            element.textContent = businessName;
        });
        
        const businessShort = jsonData["Nombre corto"];
        const elements2 = document.querySelectorAll('.short-name');
         elements2.forEach(element => {
            element.textContent = businessShort;
        });
        document.getElementById("domicilio_business").textContent = jsonData["Domicilio fiscal"];
        document.getElementById("rfc_business").textContent = jsonData["RFC con homoclave"];
        
        const representante = jsonData["Nombre Representante o Apoderado legal"];
        const elements3 = document.querySelectorAll('.representante-name');
         elements3.forEach(element => {
            element.textContent = representante;
        });
        
        const infoEscri = jsonData["Info de Escritura"];
        const partsEscrit = infoEscri.split(",");
        const noEscrituraElement = document.getElementById("no.escritura");
        if (noEscrituraElement) {
            noEscrituraElement.textContent = partsEscrit[2];
        }
        
        const notarioNombreElement = document.getElementById("notarioNombre");
        if (notarioNombreElement) {
            notarioNombreElement.textContent = partsEscrit[3];
        }
        
        const noNotarioElement = document.getElementById("no.notario");
        if (noNotarioElement) {
            noNotarioElement.textContent = partsEscrit[1];
        }
        
        const ciudadEscritElement = document.getElementById("ciudadEscrit");
        if (ciudadEscritElement) {
            ciudadEscritElement.textContent = partsEscrit[0];
        }
       
    })
    .catch(error => {
        console.error('There was a problem with the fetch operation:', error);
    });



});