function fetchData(url, retryCount = 1) {
  return new Promise((resolve, reject) => {
    fetch(url, {
      // Disable HTTPS
      mode: 'no-cors',
      headers: {
        'Content-Type': 'application/json', // Add any additional headers here
        // You can add more headers if needed
      }
    })
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not ok');
      }
      return response.json();
    })
    .then(data => {
      resolve(data); // Resolve the promise with the fetched data
    })
    .catch(error => {
      if (retryCount > 0) {
        console.log(`Retrying... Attempts left: ${retryCount}`);
        // Retry the fetch operation with decremented retry count
        fetchData(url, retryCount - 1)
          .then(data => {
            resolve(data); // Resolve the promise with the retried data
          })
          .catch(error => {
            reject(error); // Reject the promise if retries fail
          });
      } else {
        reject(error); // Reject the promise if retries are exhausted
      }
    });
  });
}

// Usage
fetchData('http://ec2-18-233-6-60.compute-1.amazonaws.com:3000/api/BDR2108276K4', 2)
  .then(data => {
    // Handle successful response
    console.log(data);
    // Party time!
  })
  .catch(error => {
    // Handle error
    console.error('Error fetching data:', error);
    AlertService.RaiseErrorAlert("Flickr temporarily unavailable. Please try again later");
  });
