document.addEventListener("DOMContentLoaded", function() {
    // Retrieve the rowData from the session
    var rowData = sessionStorage.getItem('rowData');
    var rowDataObj = JSON.parse(rowData);
    // Log the rowDataObj to the console
    console.log(rowDataObj);
    
    //////Variables para el cálulo///
    const tasa = rowDataObj["Tasa"];
    const c = rowDataObj["Comision"];
    const monto= rowDataObj["Monto"];
    const peri = parseFloat(rowDataObj["Periodicidad"]);
    const plzo= parseFloat(rowDataObj["Plazo"]);

    const fecha_inicio= rowDataObj["Fecha de inicio"];
    
    console.log("Fecha de inicio:", fecha_inicio);
    
    interestic = parseFloat(tasa);
    console.log(interestic);
    com = parseFloat(c);
    console.log(com);
    amount = parseFloat(monto.replace("$", "").replace(/,/g, ""));
    console.log(amount);
    periodo = parseFloat(peri);
    console.log("Periodo:", periodo);
    const plazo = parseFloat(plzo);
    console.log("Plazo:", plazo);

    n = Math.floor(plazo / periodo); // Redondear hacia abajo
    console.log(n);
        localStorage.setItem('numperiodos', n);
      
        const amountt = amount;
        let comision = com * 0.01 ;
        let interes = interestic * 0.01 * (periodo / 360) ;
        console.log(interes);
        payment = amountt * (1 + comision) * interes / (1 - Math.pow(1 + interes, -n));
      
        // Utilizar el valor redondeado de n en los cálculos
        payment = amountt * (1 + comision) * interes / (1 - Math.pow(1 + interes, -n));
        d = payment * n;
        
        let cost = (((d / amountt - 1) * 100) * 12) / ((plazo / 30) * 1.16);
        
        var amort = [0];
        var int = [0];
        var saldo_inicial = [amountt * (1 + comision)];
        var saldo_final = [amountt * (1 + comision)];
        var pago = [0];
        var iva = [0];
  
        //Nuestro loop con ecuaciones en diferencia
        for (let i = 0; i <= n; i++) {
            pago[i + 1] = payment;
            int[i + 1] = saldo_final[i] * interes / 1.16;
            iva[i + 1] = int[i + 1] * 0.16;
            amort[i + 1] = payment - int[i + 1] - iva[i + 1];
            saldo_inicial[i + 1] = saldo_final[i] + int[i + 1] + iva[i + 1];
            saldo_final[i + 1] = saldo_final[i] - amort[i + 1];      
        }
          
    
    localStorage.setItem('capital_d', d)
    var hoy = new Date(fecha_inicio.replace(/-/g, '\/'));
    console.log("Hoy", hoy);
    var fecha = [hoy];
    var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    var inicio = [hoy.toLocaleDateString('es-ES', options)];
    var periodos = [0];
    
    // Creemos una función que nos permita sumar periodos
    var numOfDays = periodo; // Número de días a sumar, puedes cambiarlo a lo que necesites.

    function addDays(numOfDays, date) {
        date.setDate(date.getDate() + numOfDays);
        return date
    }

    // Un loopsillo de periodos y fechas. Lo separamos por obvias razones
    for (let i = 0; i <= n; i++) {
        periodos[i + 1] = periodos[i] + 1;
        fecha[i + 1] = addDays(numOfDays * (i + 1), new Date(hoy)); // Sumamos el total de días acumulados hasta el momento
    }
    fecha[0] = addDays(numOfDays * 0, new Date(hoy)); // Sumamos el total de días acumulados hasta el momento
      console.log("Fecha vector:", fecha)

    //Loop formato de fechas
    for (let i = 0; i <= n; i++) {
        fecha[i] = new Date(fecha[i]).toLocaleDateString('es-ES', options);
    }

    //Otro loopsillo para añadir formato:    
    for (let i = 0; i <= n; i++) {
        saldo_inicial[i + 1] = saldo_inicial[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        saldo_final[i + 1] = saldo_final[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        int[i + 1] = int[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        iva[i + 1]  = iva[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        amort[i + 1]  = amort[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        pago[i + 1] = pago[i + 1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","); 
    }    
    saldo_inicial[0] = saldo_inicial[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    saldo_final[0] = saldo_final[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    iva[0] = iva[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    int[0] = int[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    pago[0] = pago[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    amort[0] = amort[0].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  
    //Ahora crearemos una tabla en HTML con la anterior información
    var headers = ["Periodo", "Saldo Inicial", "Interés", "I.V.A.", "Amortización", "Pago parcial", "Saldo Final", "Fecha"];
    var table = document.createElement("TABLE");  //makes a table element for the page
        
    for (let i = 0; i <= n; i++) {
        var row = table.insertRow(i);                       
        row.insertCell(0).innerHTML = periodos[i];
        row.insertCell(1).innerHTML = `$${saldo_inicial[i]}`;
        row.insertCell(2).innerHTML = `$${int[i]}`;
        row.insertCell(3).innerHTML = `$${iva[i]}`;
        row.insertCell(4).innerHTML = `$${amort[i]}`; 
        row.insertCell(5).innerHTML = `$${pago[i]}`;
        row.insertCell(6).innerHTML = `$${saldo_final[i]}`; 
        row.insertCell(7).innerHTML = fecha[i];       
    }

    var header = table.createTHead();
    var headerRow = header.insertRow(0);
    for (let i = 0; i < headers.length; i++) {
        headerRow.insertCell(i).innerHTML = headers[i];
    }
    
    const myData = table;
    console.log(myData.innerHTML);
    document.getElementById('tabla').innerHTML = myData.innerHTML;      
    document.getElementById('tabla2').innerHTML = myData.innerHTML;   
    document.getElementById("capital").textContent = `$${amount.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`;
    document.getElementById("com").textContent = `${(com/1.16).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}%`;
    document.getElementById("tasa").textContent = `${(interestic/1.16).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}%`;
    document.getElementById("tasa2").textContent = `${(interestic/1.16).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}%`;
    document.getElementById("capital2").textContent =  `${d.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`
    document.getElementById("capital3").textContent =  `${d.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`
    localStorage.setItem('tasa', interestic/1.16)
    
  
    const anexo = rowDataObj["No. Anexo"];
    document.getElementById("display_numero_anexo").textContent = anexo;
    const contMtro = rowDataObj["No. Contrato Maestro"];
    document.getElementById("display_numero_contrato").textContent = contMtro;
    const fechafirmaCM = (new Date(rowDataObj["Fecha de firma de Contrato Maestro"].replace(/-/g, '\/'))).toLocaleDateString('es-ES', options);
    document.getElementById("display_fecha_firma").textContent = fechafirmaCM;
    const nameAcreditada = rowDataObj["Nombre de Acreditada"]
    document.getElementById("display_denominacion").textContent = nameAcreditada;
    if(rowDataObj["No. Bienes pignorados"] == "1"){
        document.getElementById("display_bien1_folio").textContent = rowDataObj["Folio fiscal"]; 
        document.getElementById("display_bien1_descripcion").textContent = rowDataObj["Descripción"];
        document.getElementById("display_bien1_accesorios").textContent = rowDataObj["Accesorios"]; 
        document.getElementById("display_bien1_precio").textContent = rowDataObj["Precio"];
    } else if (rowDataObj["No. Bienes pignorados"] == "2"){
        document.getElementById("display_bien1_folio").textContent = rowDataObj["Folio fiscal"]; 
        document.getElementById("display_bien1_descripcion").textContent = rowDataObj["Descripción"];
        document.getElementById("display_bien1_accesorios").textContent = rowDataObj["Accesorios"]; 
        document.getElementById("display_bien1_precio").textContent = rowDataObj["Precio"];
        document.getElementById("display_bien2_folio").textContent = rowDataObj["Folio fiscal Bien 2"]; 
        document.getElementById("display_bien2_descripcion").textContent = rowDataObj["Descripción Bien 2"];
        document.getElementById("display_bien2_accesorios").textContent = rowDataObj["Accesorios Bien 2"]; 
        document.getElementById("display_bien2_precio").textContent = rowDataObj["Precio Bien 2"];
    }
    if (rowDataObj["Observaciones"] == null){
        document.getElementById("display_bien1_observaciones").textContent = "Todos y cada uno de los bienes, instrumentos, dispositivos, muebles o equipos que sean objeto de la compra por medio de la disposición del presente crédito; Todos y cada uno de los bienes, instrumentos, dispositivos, muebles o equipos descritos y enlistados en dicha Factura contenida en el Anexo B"
    } else{
    document.getElementById("display_bien1_observaciones").textContent = rowDataObj["Observaciones"];
    }
    const obliSolid = rowDataObj["Obligado Solidario"]
    document.getElementById("display_obligado_solidario").textContent = obliSolid;  
    document.getElementById("display_destino").textContent = rowDataObj["Destino"]; 
    document.getElementById("fecha_vencimiento").textContent = fecha[n]; 
    document.getElementById("fecha_inicio3").textContent = fecha[0]; 
    document.getElementById("pago_parcial").textContent = `$${payment.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`; 
    
    const apoderado= rowDataObj["Representante Legal"]
    const typeA = rowDataObj["Acreditada"];
    console.log(typeA);
    if(typeA == "Persona física"){
        document.getElementById('denominacion_display').textContent = nameAcreditada;
        document.getElementById('denominacion2').textContent = nameAcreditada;
    } else if (typeA == "Persona moral"){
        document.getElementById('denominacion_display').textContent = "Representada: " + nameAcreditada;
        document.getElementById('apoderado_acreditada_display').textContent = "Representante legal: " + apoderado;
        document.getElementById('denominacion2').textContent = "Representada: " + nameAcreditada;
        document.getElementById('apoderado2').textContent = "Representante legal: " + apoderado;
    }
});