const formID5 = '240436035647859';
const apiKey5 = '6e2676fa4067aecefdfae6fca7c4bb41';

// Get a reference to the table container element
var tableContainer5 = document.getElementById('table-container');

// Fetch form submissions from JotForm API
fetch(`https://api.jotform.com/form/${formID5}/submissions?apiKey=${apiKey5}`)
  .then(response => response.json())
  .then(data => {
    // Assuming the form submission data is stored in the 'response' variable
    var submissions = data.content;

    var jsonData = [];

    submissions.forEach(submission => {
      var response = submission.answers;
      const answerTextPairs = [];

      Object.entries(response).forEach(([key, value]) => {
        if (value.hasOwnProperty("answer") && value.hasOwnProperty("text")) {
          // Check if the value is an object
          if (Object.prototype.toString.call(value.answer) === "[object Object]") {
            value.answer = Object.values(value.answer).join(" ");
          }
          answerTextPairs.push([value.answer, value.text]);
        }
      });

      const newDictionary = answerTextPairs.reduce((dictionary, [answer, text]) => {
        dictionary[text] = answer;
        return dictionary;
      }, {});

      jsonData.push(newDictionary);
    });

    // Create the table element
    var table5 = document.createElement('table');

    // Create the table header row with the counter column
    var thead = document.createElement('thead');
    var headerRow = document.createElement('tr');

    // Create the counter header cell
    var counterHeaderCell = document.createElement('th');
    counterHeaderCell.textContent = 'Counter';
    counterHeaderCell.classList.add("text-uppercase", "text-secondary", "text-xxs", "font-weight-bolder", "opacity-7");
    headerRow.appendChild(counterHeaderCell);
    
    

    // Get all unique keys from the jsonData
    var keys = Object.keys(jsonData[0]);

    // Create the table header cells for each key
    keys.forEach(function(key) {
      var headerCell = document.createElement('th');
      headerCell.textContent = key;
      headerCell.classList.add("text-uppercase", "text-secondary", "text-xxs", "font-weight-bolder", "opacity-7");
      headerRow.appendChild(headerCell);
    });
    
      // Create the Details header cell
    var detailsHeaderCell = document.createElement('th');
    detailsHeaderCell.textContent = 'Reporte';
    detailsHeaderCell.classList.add("text-uppercase", "text-secondary", "text-xxs", "font-weight-bolder", "opacity-7");
    headerRow.appendChild(detailsHeaderCell);
    // Add the header row to the thead
    thead.appendChild(headerRow);

    // Append the thead to the table
    table5.appendChild(thead);

    // Iterate over the jsonData to create table rows
    jsonData.forEach(function(entry, index) {
      var row = document.createElement('tr');

      // Create the counter cell for each row
      var counterCell = document.createElement('td');
      counterCell.textContent = index + 1;
      row.appendChild(counterCell);
      
    
          // Create the ID cell for each row
      var idCell = document.createElement('td');
      var idButton = document.createElement('button');
      idButton.textContent = 'Descargar reporte';
      idButton.classList.add("btn", "btn-info");
      idButton.addEventListener('click', function() {
        window.location.href = `https://www.jotform.com/server.php?action=getSubmissionPDF&sid=${entry.id}&formID=${formID3}`;
      });
      idCell.appendChild(idButton);
      row.appendChild(idCell); 
      
      // Create the remaining cells for each key
      keys.forEach(function(key) {
        var cell = document.createElement('td');
        cell.textContent = entry[key];
        row.appendChild(cell);
      });

      // Add the row to the table
      table5.appendChild(row);
    });

    // Append the table to the table container
    tableContainer5.appendChild(table5);
    console.log(jsonData.length);
  })
  .catch(error => {
    // Handle any errors that occur during the request
    console.error(error);
  });
