////////////////////////////////Funcion de tasa a letra/////////////////////////////////
const numALetra = (num) => {
      let data = {
        numero: num,
        enteros: Math.floor(num),
        decimales: Math.round(num * 100) - Math.floor(num) * 100,
        letrasDecimales: '',
      }
    
      if (data.decimales > 0) data.letrasDecimales = ' punto ' + Millones(data.decimales)
    
      if (data.enteros == 0) return 'cero' + data.letrasDecimales
      if (data.enteros == 1) return Millones(data.enteros) + data.letrasDecimales
      else return Millones(data.enteros) + data.letrasDecimales
    }
    
    const Unidades = (num) => {
      const aLetras = {
        1: 'uno',
        2: 'dos',
        3: 'tres',
        4: 'cuatro',
        5: 'cinco',
        6: 'seis',
        7: 'siete',
        8: 'ocho',
        9: 'nueve',
      }
    
      return aLetras[num] || ''
    } // Unidades()
    
    const Decenas = (num) => {
      let decena = Math.floor(num / 10)
      let unidad = num - decena * 10
    
      const aLetras = {
        1: (() => {
          const aLetra = {
            0: 'diez',
            1: 'once',
            2: 'doce',
            3: 'trece',
            4: 'catorce',
            5: 'quince',
          }
          return aLetra[unidad] || 'dieci' + Unidades(unidad)
        })(),
        2: unidad == 0 ? 'veinte' : 'veinti' + Unidades(unidad),
        3: DecenasY('treinta', unidad),
        4: DecenasY('cuarenta', unidad),
        5: DecenasY('cincuenta', unidad),
        6: DecenasY('sesenta', unidad),
        7: DecenasY('setenta', unidad),
        8: DecenasY('ochenta', unidad),
        9: DecenasY('noventa', unidad),
        0: Unidades(unidad),
      }
    
      return aLetras[decena] || ''
    } //Decenas()
    
    const DecenasY = (strSin, numUnidades) => {
      if (numUnidades > 0) return strSin + ' y ' + Unidades(numUnidades)
      return strSin
    } //DecenasY()
    
    const Centenas = (num) => {
      let centenas = Math.floor(num / 100)
      let decenas = num - centenas * 100
    
      const aLetras = {
        1: decenas > 0 ? 'ciento ' + Decenas(decenas) : 'cien',
        2: 'doscientos ' + Decenas(decenas),
        3: 'trescietos ' + Decenas(decenas),
        4: 'cuatroscientos ' + Decenas(decenas),
        5: 'quinientos' + Decenas(decenas),
        6: 'seiscientos ' + Decenas(decenas),
        7: 'setecientos ' + Decenas(decenas),
        8: 'ochocientos ' + Decenas(decenas),
        9: 'novecientos ' + Decenas(decenas),
      }
    
      return aLetras[centenas] || Decenas(decenas)
    } //Centenas()
    
    const Seccion = (num, divisor, strSingular, strPlural) => {
      let cientos = Math.floor(num / divisor)
      let resto = num - cientos * divisor
    
      let letras = ''
    
      if (cientos > 0)
        if (cientos > 1) letras = Centenas(cientos) + ' ' + strPlural
        else letras = strSingular
    
      if (resto > 0) letras += ''
    
      return letras
    } //Seccion()
    
    const Miles = (num) => {
      let divisor = 1000
      let cientos = Math.floor(num / divisor)
      let resto = num - cientos * divisor
    
      let strMiles = Seccion(num, divisor, 'un mil', 'mil')
      let strCentenas = Centenas(resto)
    
      if (strMiles == '') return strCentenas
      return strMiles + ' ' + strCentenas
    } //Miles()
    
    const Millones = (num) => {
      let divisor = 1000000
      let cientos = Math.floor(num / divisor)
      let resto = num - cientos * divisor
    
      let strMillones = Seccion(num, divisor, 'un millon de', 'millones de')
      let strMiles = Miles(resto)
    
      if (strMillones == '') return strMiles
      return strMillones + ' ' + strMiles
} 
    
///////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////Función de monto a letra//////////////////////////////////////////
   
    
 const filterNum = (input) => {
    if (typeof input !== "string") {
        console.error("Input is not a string");
        return "";
    }

    const numericalChar = new Set([".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]);
    const filteredStr = input.split("").filter(char => numericalChar.has(char)).join("");
    return filteredStr;
}
  const centavosFormatter = new Intl.NumberFormat('en-US', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2,
  });



function numeroALetras(cantidad) {

    var numero = 0;
    cantidad = filterNum(cantidad);
    cantidad = parseFloat(cantidad);

    if (cantidad == "0.00" || cantidad == "0") {
        return "cero pesos con 00/100 M.N.";
    } else {        
        var ent = cantidad.toString().split(".");
        var arreglo = separar_split(ent[0]);
        var longitud = arreglo.length;

        switch (longitud) {
            case 1:
                numero = unidades(arreglo[0]);
                break;
            case 2:
                numero = decenas(arreglo[0], arreglo[1]);
                break;
            case 3:
                numero = centenas(arreglo[0], arreglo[1], arreglo[2]);
                break;
            case 4:
                numero = unidadesdemillar(arreglo[0], arreglo[1], arreglo[2], arreglo[3]);
                break;
            case 5:
                numero = decenasdemillar(arreglo[0], arreglo[1], arreglo[2], arreglo[3], arreglo[4]);
                break;
            case 6:
                numero = centenasdemillar(arreglo[0], arreglo[1], arreglo[2], arreglo[3], arreglo[4], arreglo[5]);
                break;
            case 7:
                numero = unidadesdemillon(arreglo[0], arreglo[1], arreglo[2], arreglo[3], arreglo[4], arreglo[5], arreglo[6]);
                break;
            case 8:
                numero = decenasdemillon(arreglo[0], arreglo[1], arreglo[2], arreglo[3], arreglo[4], arreglo[5], arreglo[6], arreglo[7]);
                break;
            case 9:
                numero = centenasdemillon(arreglo[0], arreglo[1], arreglo[2], arreglo[3], arreglo[4], arreglo[5], arreglo[6], arreglo[7], arreglo[8]);
                break;
            default:
                numero = "_____________________________________________________________________ ";
                break;
        }

        ent = centavosFormatter.format(parseFloat(cantidad)).toString().split(".");
        ent[1] = isNaN(ent[1]) ? '00' : ent[1];

        if (numero == 'un '){ 
          return "un peso con" + ent[1] + "/100 M.N.";
        }
        if (numero == 'un mil'){ 
          return "mil pesos con " + ent[1] + "/100 M.N.";
        }

        return numero + "pesos con " + ent[1] + "/100 M.N.";
      }


  function unidades(unidad) {
      var unidades = Array('un ', 'dos ', 'tres ', 'cuatro ', 'cinco ', 'seis ', 'siete ', 'ocho ', 'nueve ');


      return unidades[unidad - 1];
  }

  function decenas(decena, unidad) {
      var diez = Array('once ', 'doce ', 'trece ', 'catorce ', 'quince ', 'dieciseis ', 'diecisiete ', 'dieciocho ', 'diecinueve ');
      var decenas = Array('diez ', 'veinte ', 'treinta ', 'cuarenta ', 'cincuenta ', 'sesenta ', 'setenta ', 'ochenta ', 'noventa ');

      if (decena == 0 && unidad == 0) {
          return "";
      }

      if (decena == 0 && unidad > 0) {
          return unidades(unidad);
      }

      if (decena == 1) {
          if (unidad == 0) {
              return decenas[decena - 1];
          } else {
              return diez[unidad - 1];
          }
      } else if (decena == 2) {
          if (unidad == 0) {
              return decenas[decena - 1];
          }
          else if (unidad == 1) {
              return veinte = "veinti" + "un ";
          }
          else {
              return veinte = "veinti" + unidades(unidad);
          }
      } else {

          if (unidad == 0) {
              return decenas[decena - 1] + " ";
          }
          if (unidad == 1) {
              return decenas[decena - 1] + " y " + "un ";
          }

          return decenas[decena - 1] + " y " + unidades(unidad);
      }
  }

  function centenas(centena, decena, unidad) {
      var centenas = Array("ciento ", "doscientos ", "trescientos ", "cuatrocientos ", "quinientos ", "seiscientos ", "setecientos ", "ochocientos ", "novecientos ");

      if (centena == 0 && decena == 0 && unidad == 0) {
          return "";
      }
      if (centena == 1 && decena == 0 && unidad == 0) {
          return "cien ";
      }

      if (centena == 0 && decena == 0 && unidad > 0) {
          return unidades(unidad);
      }

      if (decena == 0 && unidad == 0) {
          return centenas[centena - 1] + "";
      }

      if (decena == 0) {
          var numero = centenas[centena - 1] + "" + decenas(decena, unidad);
          return numero.replace(" y ", " ");
      }
      if (centena == 0) {
          return decenas(decena, unidad);
      }

      return centenas[centena - 1] + "" + decenas(decena, unidad);

  }

  function unidadesdemillar(unimill, centena, decena, unidad) {
      var numero = unidades(unimill) + "mil " + centenas(centena, decena, unidad);
      numero = numero.replace("un mil ", "mil ");
      if (unidad == 0) {
          return numero.replace(" y ", " ");
      } else {
          return numero;
      }
  }

  function decenasdemillar(decemill, unimill, centena, decena, unidad) {
      var numero = decenas(decemill, unimill) + "mil " + centenas(centena, decena, unidad);
      return numero;
  }

  function centenasdemillar(centenamill, decemill, unimill, centena, decena, unidad) {
      var numero = 0;
      numero = centenas(centenamill, decemill, unimill) + "mil " + centenas(centena, decena, unidad);
      return numero;
  }

  function unidadesdemillon(unimillon, centenamill, decemill, unimill, centena, decena, unidad) {
    var centenasDeMillar = centenasdemillar(centenamill, decemill, unimill, centena, decena, unidad);
    if (centenasDeMillar == "mil ") {centenasDeMillar = "de "};
    if (unimillon == 1){
      var numero = unidades(unimillon) + "millon " + centenasDeMillar;
    } else {
      var numero = unidades(unimillon) + "millones " + centenasDeMillar;
    }

    if (unidad == 0) {  
    return numero.replace(" y ", " ");
    } else {
    return numero;
    }
  }

  function decenasdemillon(decemillon, unimillon, centenamill, decemill, unimill, centena, decena, unidad) {
      var centenasDeMillar = centenasdemillar(centenamill, decemill, unimill, centena, decena, unidad);
      if (centenasDeMillar == "mil ") { centenasDeMillar = "de "};
      var numero = decenas(decemillon, unimillon) + "millones " + centenasDeMillar;
      return numero;
  }

  function centenasdemillon(centenamillon, decemillon, unimillon, centenamill, decemill, unimill, centena, decena, unidad) {
      var centenasDeMillar = centenasdemillar(centenamill, decemill, unimill, centena, decena, unidad);
      if (centenasDeMillar == "mil ") { centenasDeMillar = "de "};
      var numero = centenas(centenamillon, decemillon, unimillon) + "millones " + centenasDeMillar;
      return numero;
  }

  function separar_split(texto) {
      var contenido = new Array();
      for (var i = 0; i < texto.length; i++) {
          contenido[i] = texto.substr(i, 1);
      }
      return contenido;
  }

}  
 
    
    

