document.addEventListener("DOMContentLoaded", function() {
    // Retrieve the rowData from the session
    var rowData = sessionStorage.getItem('rowData');
    var rowDataObj = JSON.parse(rowData);
    // Log the rowDataObj to the console
    console.log(rowDataObj);
    
    //////Variables para el cálulo///
    const tasa = rowDataObj["Tasa"];
    localStorage.setItem('tasa', tasa);
    const com = rowDataObj["Comision"];
    localStorage.setItem('c', com);
    const monto= rowDataObj["Monto"];
    localStorage.setItem('monto', monto);
    const periodo = parseFloat(rowDataObj["Periodicidad"]);
    localStorage.setItem('periodo', periodo);
    const plzo= rowDataObj["Plazo"];
    localStorage.setItem('plazo', plzo);
    document.getElementById("plazodecredito").textContent = plzo/30 + " meses";
    const fechai= rowDataObj["Fecha de inicio"];
    localStorage.setItem('fechai', fechai);
    
    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' }; // Options for formatting the date
    
    
    // Unpack each variable
    const nombrePF = rowDataObj["Nombre completo"];
    document.getElementById("nombre").textContent = nombrePF;
    const id = rowDataObj["id"];
    document.getElementById("id").textContent = id;
    const parcialidad = rowDataObj["Parcialidad"];
    document.getElementById("parcialidad").textContent = `$${parcialidad}`;
    //const fechai = rowDataObj["Fecha de inicio"];
    var partesFecha = fechai.split("/");

    // Formar la fecha en formato "aaaa-mm-dd"
    var fecha_inicio = partesFecha[2] + "-" + partesFecha[1].padStart(2, '0') + "-" + partesFecha[0].padStart(2, '0');
    var formattedfecha_inicio = new Date(fecha_inicio.replace(/-/g, '\/'));
    var fechaini = [formattedfecha_inicio.toLocaleDateString('es-ES', options)];
    document.getElementById("fecha_inicio").textContent = fechaini;
    
    
    //const periodo = parseFloat(rowDataObj["Periodicidad"]);
    console.log("Periodo", periodo);
    
    const hoy = new Date();
    
    function generarFechasDePago(cantidadPagos, periodo) {
    let fechaMasReciente = null; // Inicializamos la fecha más reciente como null

    let fechaActual = new Date();

    for (let i = 0; i < cantidadPagos; i++) {
        let dia;
        let ultdia;

        switch (periodo) {
            case 7: // Every Friday
                while (fechaActual.getDay() !== 5) { // While the day is not Friday
                    fechaActual.setDate(fechaActual.getDate() + 1); // Move to the next day
                }
                dia = fechaActual.getDate();
                break;
            case 14: // Every 14th and 28th day of the month
                dia = 14;
                ultdia = 28;
                break;
            case 15: // Every 15th and last day of the month
                dia = 15;
                ultdia = new Date(fechaActual.getFullYear(), fechaActual.getMonth() + 1, 0).getDate(); // Get last day of the month
                break;
            case 28: // Every 28th day of the month
                dia = 28;
                break;
            case 30: // Last day of the month
                dia = new Date(fechaActual.getFullYear(), fechaActual.getMonth() + 1, 0).getDate();
                break;
            default:
                throw new Error("Invalid value for periodo");
        }

        // Create the payment date
        let nuevaFechaPago = new Date(fechaActual.getFullYear(), fechaActual.getMonth(), dia);

        // Si la fecha es más reciente que la fecha anteriormente almacenada, actualiza la fecha más reciente
        if (fechaMasReciente === null || nuevaFechaPago > fechaMasReciente) {
            fechaMasReciente = nuevaFechaPago;
        }

        // If 14th or 28th, add the other day
        if (periodo === 14 || periodo === 15) {
            let otraFechaPago = new Date(fechaActual.getFullYear(), fechaActual.getMonth(), ultdia);
            if (fechaMasReciente === null || otraFechaPago > fechaMasReciente) {
                fechaMasReciente = otraFechaPago;
            }
        }

        // Move to the next month if needed
        if (periodo !== 7) {
            fechaActual.setMonth(fechaActual.getMonth() + 1);
        }
    }

    return fechaMasReciente;
}

// Llamada a la función y cálculo de la diferencia
let fechaEspecifica = generarFechasDePago(1, periodo); // Por ejemplo, generamos 5 fechas de pago cada 14 días
let fechaSigPago = fechaEspecifica.toLocaleDateString('es-ES', options)
document.getElementById("fechaSigPago").textContent = fechaSigPago;

let fechaDeHoy = new Date();
let diferenciaEnMilisegundos = fechaEspecifica - fechaDeHoy;
let diferenciaEnDias = Math.floor(diferenciaEnMilisegundos / (1000 * 60 * 60 * 24));
document.getElementById("countDays").textContent = diferenciaEnDias + " días para la fecha de pago";

    /////Línea de crédito//////
    const antgdd = rowDataObj["Tiempo en su trabajo actual:"];
    const salario = parseFloat(rowDataObj["Ingreso mensual de nómina"].replace(/[^\d.-]/g, '').replace("$", ""));
    
    let porclineaMax;
    if (antgdd == "menos de 2 años") {
        porclineaMax = 0.30;
    } else if (antgdd == "de 2 a 3 años") {
        porclineaMax = 0.70;
    } else if (antgdd == "de 3 a 4 años") {
        porclineaMax = 1;
    } else if (antgdd == "de 4 a 5 años") {
        porclineaMax = 1.5;
    } else if (antgdd == "de 5 a 9 años") {
        porclineaMax = 1;
    }

    const lineaMax = salario*porclineaMax;
    document.getElementById("linea_max").textContent = `$${lineaMax}` ;
    const amount= parseFloat(rowDataObj["Monto"].replace("$", ""));
    console.log(amount)
    document.getElementById("amount_actual").textContent = `$${amount}` ;
    const amount_disponible = lineaMax-amount
    console.log(amount_disponible)
    document.getElementById("amount_dispo").textContent = `$${amount_disponible}`
});