function loginUser() {
    // Get the submission ID entered by the user
    var submissionID = document.getElementById("submissionID").value.trim();
    

    // Replace 'YOUR_API_KEY' with your actual JotForm API key
    var apiKey = '6e2676fa4067aecefdfae6fca7c4bb41';

    // Make sure submission ID is not empty
    if (submissionID === '') {
        alert("Please enter a submission ID.");
        return; // Ensure the return statement is within the function scope
    }

    // Make API call to retrieve info
    var apiUrl = "https://api.jotform.com/submission/" + submissionID + "?apiKey=" + apiKey;

    // Use fetch to make the API call
    fetch(apiUrl)
        .then(response => {
            // Check if response is successful
            if (response.status !== 200) {
                throw new Error('Error. Por favor, escriba su contrase\u00f1a.');
            }
            // Parse response as JSON
            return response.json();
        })
        .then(data => {
            // Check if content.answers exists
            if (!data.content || !data.content.answers) {
                throw new Error('Contrase\u00f1a incorrecta. Intente de nuevo.');
            }
        
            // Extract answers from data
            var submissions = data.content;
            var jsonData = {}; // Initialize as an empty object
            
            var response = data.content.answers;
            const answerTextPairs = [];
            
            Object.entries(response).forEach(([key, value]) => {
                if (value.hasOwnProperty("answer") && value.hasOwnProperty("text")) {
                    // Check if the value is an object
                    if (Object.prototype.toString.call(value.answer) === "[object Object]") {
                        value.answer = Object.values(value.answer).join(", ");
                    }
                    answerTextPairs.push([value.answer, value.text]);
                }
            });
            
            const newDictionary = answerTextPairs.reduce((dictionary, [answer, text]) => {
                dictionary[text] = answer;
                return dictionary;
            }, {});
            
            // Assign the newDictionary object to jsonData
            jsonData = newDictionary;
            sessionStorage.setItem('rowData', JSON.stringify(jsonData));
            localStorage.setItem('rowData', JSON.stringify(jsonData));
            localStorage.setItem('id_form' , submissionID);
            // Set login message based on success or failure
            var loginMessage = document.getElementById("loginMessage");
            var typeprof = document.getElementById("typeProfile").value;
            
            if (typeprof == 0 || typeprof == 1 || typeprof == 2 || typeprof == 3 || typeprof == 4) {
                loginMessage.textContent = "Inicio de sesi\u00f3n exitoso. Redirigiendo a la p\u00e1gina de perfil...";
                // Redirect to profile page after a brief delay (for demo purposes)
                setTimeout(() => {
                    if (typeprof == 1) {
                        window.location.href = "https://vilarkptl.com/dashboard/pages/publicprofilecredit.html";
                    } else if (typeprof == 0 ) {
                        window.location.href = "https://vilarkptl.com/dashboard/pages/publicprofile_anexos.html";
                    }else if (typeprof == 2 ||typeprof == 3  ) {
                        window.location.href = "https://vilarkptl.com/dashboard/pages/publicprofileinv.html";
                    } else if (typeprof == 4) {
                        window.location.href = "https://vilarkptl.com/dashboard/pages/publicprofilecajainv.html";
                    }
                }, 2000);
            } else {
                loginMessage.textContent = "Tipo de perfil inv\u00e1lido. Por favor, int\u00e9ntelo de nuevo.";
            }
        })
        .catch(error => {
            // Handle errors
            var loginMessage = document.getElementById("loginMessage");
            loginMessage.textContent = error.message;
        });
}