
function computeLoan(){
    var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };  
    function addMonths(numOfMonths, date = new Date()) {
      date.setMonth(date.getMonth() + numOfMonths);

      return date.toLocaleDateString('es-ES', options);
    }
    const params = new URLSearchParams(document.location.search);
    const interest_ic = params.get("tic");
    localStorage.setItem('tic', interest_ic);
    const months = parseFloat(document.querySelector('#months').value);
    localStorage.setItem('plazo', months);
    //const amount = parseFloat(document.querySelector('#amount').value);
    const pago = parseFloat(document.querySelector('#pago').value);
    localStorage.setItem('monto', pago);
    const monto = parseFloat(document.querySelector('#monto').value);
    localStorage.setItem('monto_inicial', monto);
    const r = interest_ic*0.01/12;
    const amount = pago*((1+r)**(months)-1)/r + monto*(1+r)**(months)
    const hoy=new Date().toLocaleDateString('es-ES', options);
    localStorage.setItem('fecha', hoy);
    const moda= "Mezcla de ambas";
    localStorage.setItem('moda', moda);

    //let T = Math.log(1+amount*r_ic/pago)/Math.log(1 + r_ic);
    //let Tcetes = Math.log(1+amount*(0.0075)/pago)/Math.log(1 +0.0075);
    //let Tcetes =amount/pago+ Math.log(1+amount*(0.00725)/pago)/Math.log(1 +0.00725);
    
    let ganancia = amount - pago*(months) - monto;
    let inversion = pago*(months) + monto;
    localStorage.setItem('pagostotal', inversion);
    let payment = pago;
    //let meta = amount;
    let meta = ganancia;
    let redito = amount - pago*months - monto;
    let rentabilidad = 100*(amount/inversion-1);
    let valorf = amount;
    let plazo = months;
    let franquicias = 100*inversion/320000
    localStorage.setItem('compra', franquicias);
    let capital_t = [monto]
    let periodos = [0]
    let fechas = [new Date().toLocaleDateString('es-ES', options)]
    let rentas = r*valorf*12
        
    for (i = 0; i<=months; i++){
    
    capital_t[i+1] = capital_t[i]*(1+r) + pago
        }
        
    for (i = 0; i<months; i++){
    periodos[i+1] = periodos[i] + 1 ;
    fechas[i+1] = addMonths(i +1, new Date());

        }
    
    //let pago_total = amount + ganancia;
    //payment = payment.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","); //\B looks for a word boundary, ? says what to look for, \d looks for 3 digits in a row
    valorf = valorf.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    payment = payment.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    ganancia = ganancia.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    meta = meta.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    rentabilidad = rentabilidad.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    inversiont = inversion.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    plazo = plazo.toFixed(0).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    franquicias = franquicias.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    rentas = rentas.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    document.querySelector('#plazo').innerHTML = `${plazo} meses: exactamente ${(plazo/12).toFixed(2)} años.`
    document.querySelector('#payment').innerHTML = `$${payment}`
    document.querySelector('#earning').innerHTML = `$${ganancia}`
    document.querySelector('#meta').innerHTML = `$${meta}`
    document.querySelector('#franquicias').innerHTML = `${franquicias}%`
    document.querySelector('#rentabilidad').innerHTML = `${rentabilidad}%`
    document.querySelector('#inversion').innerHTML = `$${inversiont}`
    document.querySelector('#inversion2').innerHTML = `$${inversiont}`
    document.querySelector('#valor_futuro').innerHTML = `$${valorf}`
    document.querySelector('#plazo').innerHTML = `${plazo} meses`
    document.querySelector('#vitalicias').innerHTML = `${rentas}`
    
    Highcharts.chart('container', {
      chart: {
        type: 'column'
      },
      title: {
        text: 'Valor de compra vs. Ganancia'
      },
      subtitle: {
        text: 'A continuación se muestran valor de compra, ganancia y pago total:'
      },
      xAxis: {
        categories: [
          'Ganancia',
          'Valor de compra',
          'Total'
        ],
        crosshair: true
      },
      yAxis: {
        title: {
          useHTML: true,
          text: 'Miles de pesos mexicanos, m.n.'
        }
      },
      tooltip: {
        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
          '<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
      },
      plotOptions: {
        column: {
          pointPadding: 0.2,
          borderWidth: 0
        }
      },
      series: [{
        name: 'Inversión',
        data: [inversion],
        color: '#4f19ac'
      }, {
        name: 'Ganancia',
        data: [redito],
        color: '#cf96d9'
    
      }, {
        name: 'Total',
        data: [amount],       
        color: '#82498c'
    
      }]
    });
    
    Highcharts.chart('series', {

    title: {
        text: 'Senda de crecimiento de su franquicia'
    },

    subtitle: {
        text: 'Comportamiento de la franquicia y ganancias totales en el tiempo'
    },

    yAxis: {
        title: {
            text: 'Miles de pesos, m.n.'
        }
    },

    xAxis: {
        accessibility: {
            rangeDescription: 'Periodos en meses'
        }
    },

    legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle'
    },

    plotOptions: {
        series: {
            label: {
                connectorAllowed: false
            },
            pointStart: -1
        }
    },

    series: [{
        name: 'Valor de franquicia',
        data: capital_t,
        color: '#82498c'
    }//, {
     //   name: 'Other',
     //   data: [21908, 5548, 8105, 11248, 8989, 11816, 18274,
     //       17300, 13053, 11906, 10073]
    //}
    ],

    responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                }
            }
        }]
    }

});
var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };  
    function addMonths(numOfMonths, date = new Date()) {
        date.setMonth(date.getMonth() + numOfMonths);

        return date.toLocaleDateString('es-ES', options);
    }
    //const params = new URLSearchParams(document.location.search); 
    const interest = params.get("tic")*0.01/12;
    //const pago = parseFloat(document.querySelector('#pago').value);
    //const monto = parseFloat(document.querySelector('#monto').value);
    //const interestic = parseFloat(params.get("tic")/1200);  
    //const interestcv = parseFloat(params.get("tcv")/1200);
    const m = parseFloat(document.querySelector('#months').value);
    //const m = month-1
    localStorage.setItem( 'months', m );
    
  
    //let fechas = [currentDate]
    //let periodos = [0]
    //let fechas = [new Date().toLocaleDateString('es-ES', options)]
    let fecha = [new Date().toLocaleDateString('es-ES', options)]
    let saldo = [monto]
    
    let pagop = [- monto]
    let interes = [0]
    
    for (i = 0; i<m; i++){
    periodos[i+1] = periodos[i] + 1 ;
    fechas[i+1] = addMonths(i +1, new Date());

        }
    console.log(fechas)    
    for (i = 0; i<=m; i++){
    //capital_c[i+1] = (capital_c[i]*(1+interestic));
    saldo[i+1] = saldo[i]*(1+interest) + pago
    pagop[i+1] = -pago
    interes[i+1] = saldo[i]*interest
        }
    saldo[m] = saldo[m-1]*(1+interest)    
    pagop[m] = saldo[m]    
    //pagop[m] = saldo[m] 
    for (i = 0; i<=m; i++){ 
    saldo[i] = saldo[i].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    pagop[i] = pagop[i].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    interes[i] = interes[i].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    
    //fecha[i] = fechas[i].getUTCDay() + "/" + fechas[i].getUTCMonth()+1+"/"  + fechas[i].getUTCFullYear();
    fecha[i]= fechas[i];
        }
    var headers = ["Periodo", "Pago",
    "Ganancia", "Saldo", 
    "Fecha"];
    var table = document.createElement("TABLE");  //makes a table element for the page
        
    for(var i = 0; i <= m; i++) {
        var row = table.insertRow(i);                       
        row.insertCell(0).innerHTML = periodos[i];
        row.insertCell(1).innerHTML = pagop[i];
        row.insertCell(2).innerHTML = interes[i];
        row.insertCell(3).innerHTML = saldo[i];
        row.insertCell(4).innerHTML = fechas[i];
        
        
    }

    var header = table.createTHead();
    var headerRow = header.insertRow(0);
    for(var i = 0; i < headers.length; i++) {
        headerRow.insertCell(i).innerHTML = headers[i];
    }
    
    //document.body.append(table);
    //var myData = [header.innerHTML, row.innerHTML]
    const myData = table
    console.log(myData.innerHTML)
    localStorage.setItem( 'tabla', myData.innerHTML );
    //document.getElementById("tabla");
    document.getElementById('tabla').innerHTML = myData.innerHTML;
    //localStorage.setItem('table', document.getElementById('payment').innerHTML)

  }





            
            