function computeLoan(){
  const params = new URLSearchParams(document.location.search);
  const interestic = params.get("tic");
  const com = params.get("c");
  const amount = document.querySelector('#amount').value;
  const periodo = document.querySelector('#pago').value;
  const plazo = document.querySelector('#plazo').value;
  const fecha_inicio = document.querySelector('#fecha_inicio').value;
  let n = Math.floor(plazo / periodo); // Redondear hacia abajo
  
  const amountt = 1 * amount;
  //const date = new Date();
  let comision = com * 0.01;
  let interes = interestic * 0.01 * (periodo / 360);
  let payment = amountt * (1+comision) * interes / (1 - Math.pow(1 + interes, -n));
  
  // Utilizar el valor redondeado de n en los cálculos
  payment = amountt * (1 + comision) * interes / (1 - Math.pow(1 + interes, -n));
  let d = payment*n
  let cost = (d/amountt-1)*100
  
 // Vectores que utilizaremos en el loop que genera la tabla
  var hoy = new Date(fecha_inicio);
  var fecha = [hoy.toLocaleDateString('es-ES', options)];
  var periodos = [0];

  // Creemos una función que nos permita sumar periodos
  var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  var numOfDays = periodo; // Número de días a sumar, puedes cambiarlo a lo que necesites.

  function addDays(numOfDays, date) {
    date.setDate(date.getDate() + numOfDays);
    return date.toLocaleDateString('es-ES', options);
  }

  // Un loopsillo de periodos y fechas. Lo separamos por obvias razones
  for (var i = 0; i <= n; i++) {
    periodos[i + 1] = periodos[i] + 1;
    fecha[i + 1] = addDays(numOfDays * (i + 1), new Date(hoy)); // Sumamos el total de días acumulados hasta el momento
  }

  amort = [0]
  int = [0]
  saldo_inicial = [amountt*(1+comision)];
  saldo_final = [amountt*(1+comision)];
  pago = [0]
  iva = [0]
  //Nuestro loop con ecuaciones en diferencia
  for (i = 0; i<=n; i++){
    pago[i+1] = payment;
    int[i+1] = saldo_final[i]*interes/1.16;
    iva[i+1] = int[i+1]*0.16;
    amort[i+1] = payment - int[i+1] - iva[i+1];
    saldo_inicial[i+1] = saldo_final[i] + int[i] + iva[i];
    saldo_final[i+1] = saldo_final[i] - amort[i+1];      
      }
  //Otro loopsillo para añadir formato:    
  for (i=0; i<=n; i++){
    saldo_inicial[i+1] = saldo_inicial[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    saldo_final[i+1] = saldo_final[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    int[i+1] = int[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    iva[i+1]  = iva[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    amort[i+1]  = amort[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    pago[i+1] = pago[i+1].toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","); 
        }    
  //Ahora crearemos una tabla en HTML con la anterior información
    var headers = ["Periodo",
    "Saldo Inicial", "Interés" , "I.V.A.",  "Amortización", "Pago parcial", 
    "Saldo Final", "Fecha"];
    var table = document.createElement("TABLE");  //makes a table element for the page
        
    for(var i = 0; i <= n; i++) {
        var row = table.insertRow(i);                       
        row.insertCell(0).innerHTML = periodos[i];
        row.insertCell(1).innerHTML = saldo_inicial[i];
        row.insertCell(2).innerHTML = int[i];
        row.insertCell(3).innerHTML = iva[i];
        row.insertCell(4).innerHTML = amort[i]; 
        row.insertCell(5).innerHTML = pago[i];
        row.insertCell(6).innerHTML = saldo_final[i]; 
        row.insertCell(7).innerHTML = fecha[i];       
    }

    var header = table.createTHead();
    var headerRow = header.insertRow(0);
    for(var i = 0; i < headers.length; i++) {
        headerRow.insertCell(i).innerHTML = headers[i];
    }
    
    const myData = table
    console.log(myData.innerHTML)
    localStorage.setItem( 'tabla', myData.innerHTML );document.getElementById('tabla').innerHTML = myData.innerHTML;      
    localStorage.setItem( 'fecha_inicio', fecha[0] );document.getElementById('fecha_inicio').textContent = fecha_inicio
    console.log(fecha_inicio)
    const capital = localStorage.getItem('capital');
    console.log(capital)
    localStorage.setItem( 'capital', capital )
    localStorage.setItem('fecha_vencimiento', fecha[n])
    localStorage.setItem('periodicidad', periodo)
    localStorage.setItem('parcialidades', n)
  
  payment = payment.toLocaleString(undefined, {maximumFractionDigits: 2});
  parcialidades = n.toLocaleString(undefined, {maximumFractionDigits: 2});
  desembolso = d.toLocaleString(undefined, {maximumFractionDigits: 2});
  linea = amountt.toLocaleString(undefined, {maximumFractionDigits: 2});
  costo = cost.toLocaleString(undefined, {maximumFractionDigits: 2});
  p = periodo.toLocaleString(undefined, {maximumFractionDigits: 0});
  term = plazo.toLocaleString(undefined, {maximumFractionDigits: 0});
 
  document.querySelector('#payment').innerHTML = `$${payment}`
  document.querySelector('#payment2').innerHTML = `$${payment}`
  document.querySelector('#payment3').innerHTML = `$${payment}`
  
  document.querySelector('#parcialidades').innerHTML = `${n}`
  document.querySelector('#parcialidades2').innerHTML = `${n}`
  document.querySelector('#desembolso').innerHTML = `$${desembolso}`
  document.querySelector('#desembolso2').innerHTML = `$${desembolso}`
  document.querySelector('#linea').innerHTML = `$${linea}`
  document.querySelector('#costo').innerHTML = `${costo}%`
  document.querySelector('#periodo2').innerHTML = `${p}`
  document.querySelector('#plazo2').innerHTML = `${term}`
  localStorage.setItem( 'pago_parcial', payment );
  localStorage.setItem( 'capital', amountt );
  localStorage.setItem( 'comision', com.toFixed(2)/1.16 );
  localStorage.setItem( 'tasa', interestic/1.16 );
  localStorage.setItem( 'desembolso', desembolso );
}


